﻿namespace Microsoft.Samples.PlanMyNight.Entities
{
    using System.ComponentModel.DataAnnotations;
    using System.Runtime.Serialization;
    using System.Web.Routing;

    [DataContract]
    public class AdvancedSearchQuery : BaseSearchQuery
    {
        [DataMember]
        [Required]
        [Range(1, int.MaxValue)]
        public int ActivityTypeId { get; set; }

        [DataMember]
        public string StreetAddress { get; set; }

        [DataMember]
        [Required]
        public string City { get; set; }

        [DataMember]
        [Required]
        public string State { get; set; }

        [DataMember]
        public string Zip { get; set; }

        [DataMember]
        public int? Radius { get; set; }

        [DataMember]
        public double? Latitude { get; set; }

        [DataMember]
        public double? Longitude { get; set; }

        public AdvancedSearchQuery Clone()
        {
            return new AdvancedSearchQuery
            {
                Type = this.Type,
                ActivityTypeId = this.ActivityTypeId,
                StreetAddress = this.StreetAddress,
                City = this.City,
                State = this.State,
                Zip = this.Zip,
                Radius = this.Radius,
                Latitude = this.Latitude,
                Longitude = this.Longitude,
                SortBy = this.SortBy,
                Page = this.Page,
                PageSize = this.PageSize
            };
        }

        public override BaseSearchQuery NewPage(int page)
        {
            var copy = this.Clone();
            copy.Page = page;
            return copy;
        }

        public override BaseSearchQuery NewSortCriteria(SortCriteria sort)
        {
            var copy = this.Clone();
            copy.SortBy = sort;
            return copy;
        }

        public override BaseSearchQuery NewType(SearchType type)
        {
            var copy = this.Clone();
            copy.Type = type;
            return copy;
        }

        public override RouteValueDictionary GetRouteValues()
        {
            var values = new RouteValueDictionary();
            values["Type"] = this.Type;
            values["ActivityTypeId"] = this.ActivityTypeId;
            values["StreetAddress"] = this.StreetAddress;
            values["City"] = this.City;
            values["State"] = this.State;
            values["Zip"] = this.Zip;
            values["Radius"] = this.Radius;
            values["Latitude"] = this.Latitude;
            values["Longitude"] = this.Longitude;
            values["SortBy"] = this.SortBy;
            values["Page"] = this.Page;
            return values;
        }
    }
}
